<?php
declare(strict_types=1);

namespace Lookways\SDK\Model;

class ClientConfig
{


    const CREDENTIAL_TYPE_PASS = 'pass';
    const CREDENTIAL_TYPE_TOKEN = 'token';

    const CREDENTIAL_TYPE_SESSION = 'session';


    public function __construct(
        protected string $backendApiUrl,
        protected ?string $clientUsername=null,
        protected ?string $clientCredential=null,
        protected ?string $credentialType=null,
    )
    {

    }

    /**
     * @return string
     */
    public function getBackendApiUrl(): string
    {
        return $this->backendApiUrl;
    }

    /**
     * @return string
     */
    public function getClientUsername(): ?string
    {
        return $this->clientUsername;
    }

    /**
     * @return string
     */
    public function getClientCredential(): ?string
    {
        return $this->clientCredential;
    }

    /**
     * @return string
     */
    public function getCredentialType(): ?string
    {
        return $this->credentialType;
    }




}